﻿using System;
using System.Web;
using Soneta.Business;
using Soneta.Ksiega;
using Soneta.Types;
using Soneta.Web;

namespace ASP {
    public partial class KPiR_Szeroki : System.Web.UI.Page {
        public string Str_SumaMiesiaca = "<strong>Suma miesiąca:</strong>";
        public string Str_SumaMiesiecy = "<strong>Suma miesięcy:</strong>";
        public string Str_Przeniesienie = "<strong>Przeniesienie z poprzednich miesięcy:</strong>";
        public string Str_Razem = "<strong>Razem od początku roku:</strong>";

        //--------------
        public class Params : ContextBase
        {
            private FromTo okres = FromTo.Empty;
            internal FromTo OkresChecked;
            internal bool SingleMonth;

            private bool pokazNumerEwidencji;
            private bool pokazPodsumowanie = true;


            public Params(Context context)
                : base(context)
            {
                RecalcOkres();
            }


            [Required]
            [Caption("Wydruk za okres")]
            [Soneta.Tools.Priority(10)]
            public FromTo Okres
            {
                get { return okres; }
                set
                {
                    okres = value;

                    RecalcOkres();
                    OnChanged(EventArgs.Empty);
                }
            }


            [Soneta.Tools.Priority(20)]
            [Caption("Pokaż nr ewidencji")]
            public bool PokazNumerEwidencji
            {
                get { return pokazNumerEwidencji; }
                set
                {
                    pokazNumerEwidencji = value;
                    OnChanged(EventArgs.Empty);
                }
            }


            [Soneta.Tools.Priority(30)]
            [Caption("Pokaż podsumowanie")]
            public bool PokazPodsumowanie
            {
                get { return pokazPodsumowanie; }
                set
                {
                    pokazPodsumowanie = value;
                    OnChanged(EventArgs.Empty);
                }
            }


            private void RecalcOkres()
            {
                if (okres == FromTo.Empty)
                    okres = new YearMonth(Date.Today).ToFromTo();

                OkresChecked = new FromTo(okres.From.ToYearMonth().FirstDay, okres.To.ToYearMonth().LastDay);
                SingleMonth = OkresChecked.IsOneMonth;
            }
        }


        [Context]
        public Params Pars { get; set; }


        private readonly decimal[] przeniesienie = new decimal[18];
        private readonly KPiR.KPiRWorker worker = new KPiR.KPiRWorker();


        protected void dc_ContextLoad(object sender, EventArgs e)
        {
            ReportHeader["OKRES"] = Pars.SingleMonth ? Pars.OkresChecked.From.ToYearMonth().ToString() : string.Format("{0} - {1}", Pars.OkresChecked.From.ToYearMonth(), Pars.OkresChecked.To.ToYearMonth());
            SectionPodsumowanie.Visible = Pars.PokazPodsumowanie;

            OkresObrachunkowy okres = (OkresObrachunkowy)dc[typeof(OkresObrachunkowy)];
            KsiegaModule ksiega = KsiegaModule.GetInstance(dc.Context);

            colS07.Caption = col07.Caption;
            colS08.Caption = col08.Caption;
            colS09.Caption = col09.Caption;
            colS10.Caption = col10.Caption;
            colS11.Caption = col11.Caption;
            colS13.Caption = col13.Caption;
            colS14.Caption = col14.Caption;
            colS15.Caption = col15.Caption;
            colS16.Caption = col16.Caption;

            Soneta.Business.View view = ksiega.Dziennik.WgKPiR.CreateView();
            view.Condition &= new FieldCondition.Equal("Okres", okres);
            view.Condition &= "KPiR.Lp>0";

            Grid.DataSource = view;
            Grid1.DataSource = new object[] { 1, 2, 3 };
        }


        protected void Grid_BeforeRow(object sender, RowEventArgs args)
        {
            DekretBase dekret = (DekretBase)args.Row;
            bool sum = dekret.KPiR.Stan != StanyZapisuKPiR.Przekreślony;
            if (dekret.Data < Pars.OkresChecked.From)
            {
                args.VisibleRow = false;
                if (sum)
                {
                    worker.Dekret = dekret;
                    przeniesienie[7] += worker.K07.Value;
                    przeniesienie[8] += worker.K08.Value;
                    przeniesienie[9] += worker.K09.Value;
                    przeniesienie[10] += worker.K10.Value;
                    przeniesienie[11] += worker.K11.Value;
                    przeniesienie[13] += worker.K13.Value;
                    przeniesienie[14] += worker.K14.Value;
                    przeniesienie[15] += worker.K15.Value;
                    przeniesienie[16] += worker.K16.Value;
                    przeniesienie[17] += worker.K17.Value;
                }
            }
            else if (dekret.Data > Pars.OkresChecked.To)
                args.VisibleRow = false;
            else
            {
                string colNumerDokumentuStr;

                if (Pars.PokazNumerEwidencji)
                    colNumerDokumentuStr = string.Format("{0} ({1})", dekret.NumerDokumentu, dekret.NumerEwidencji);
                else
                    colNumerDokumentuStr = dekret.NumerDokumentu;

                if (colNumerDokumentuStr.Length > 12)
                    colNumerDokumentuStr = string.Format("<span style='word-break:break-all;'>{0}</span>", System.Web.HttpUtility.HtmlEncode(colNumerDokumentuStr));

                colNumerDokumentu.EditValue = colNumerDokumentuStr;

                worker.Dekret = dekret;
                SetCol(col07, worker.K07.Value, sum);
                SetCol(col08, worker.K08.Value, sum);
                SetCol(col09, worker.K09.Value, sum);
                SetCol(col10, worker.K10.Value, sum);
                SetCol(col11, worker.K11.Value, sum);
                SetCol(col13, worker.K13.Value, sum);
                SetCol(col14, worker.K14.Value, sum);
                SetCol(col15, worker.K15.Value, sum);
                SetCol(col16, worker.K16.Value, sum);
                SetCol(col17, worker.K17.Value, sum);

                col16.HideZero = !worker.Remanent;
                col17Opis.EditValue = worker.K17Opis;
            }
        }


        protected void Grid1_BeforeRow(object sender, RowEventArgs args)
        {
            int n = (int)args.Row;
            switch (n)
            {
                case 1:
                    colS07.EditValue = ObjToDec(col07.TotalValue);
                    colS08.EditValue = ObjToDec(col08.TotalValue);
                    colS09.EditValue = ObjToDec(col09.TotalValue);
                    colS10.EditValue = ObjToDec(col10.TotalValue);
                    colS11.EditValue = ObjToDec(col11.TotalValue);
                    colS13.EditValue = ObjToDec(col13.TotalValue);
                    colS14.EditValue = ObjToDec(col14.TotalValue);
                    colS15.EditValue = ObjToDec(col15.TotalValue);
                    colS17.EditValue = ObjToDec(col17.TotalValue);
                    colSInfo2.EditValue = Pars.SingleMonth ? Str_SumaMiesiaca : Str_SumaMiesiecy;
                    break;
                case 2:
                    colS07.EditValue = przeniesienie[7];
                    colS08.EditValue = przeniesienie[8];
                    colS09.EditValue = przeniesienie[9];
                    colS10.EditValue = przeniesienie[10];
                    colS11.EditValue = przeniesienie[11];
                    colS13.EditValue = przeniesienie[13];
                    colS14.EditValue = przeniesienie[14];
                    colS15.EditValue = przeniesienie[15];
                    colS17.EditValue = przeniesienie[17];
                    colSInfo2.EditValue = Str_Przeniesienie;
                    break;
                case 3:
                    colS07.EditValue = przeniesienie[7] + ObjToDec(col07.TotalValue);
                    colS08.EditValue = przeniesienie[8] + ObjToDec(col08.TotalValue);
                    colS09.EditValue = przeniesienie[9] + ObjToDec(col09.TotalValue);
                    colS10.EditValue = przeniesienie[10] + ObjToDec(col10.TotalValue);
                    colS11.EditValue = przeniesienie[11] + ObjToDec(col11.TotalValue);
                    colS13.EditValue = przeniesienie[13] + ObjToDec(col13.TotalValue);
                    colS14.EditValue = przeniesienie[14] + ObjToDec(col14.TotalValue);
                    colS15.EditValue = przeniesienie[15] + ObjToDec(col15.TotalValue);
                    colS17.EditValue = przeniesienie[17] + ObjToDec(col17.TotalValue);
                    colSInfo2.EditValue = Str_Razem;
                    break;
            }
        }


        void SetCol(Soneta.Web.GridColumn col, decimal value, bool sum)
        {
            col.SumRow = sum;
            if (sum || value != 0)
            {
                col.Format = "{0:n}";
                col.EditValue = value;
            }
            else
                col.Format = "<center>-------------</center>";
        }

        decimal ObjToDec(object value)
        {
            return value == null ? 0m : (decimal)value;
        }
    }
}
